<?php
/**
 * The template for displaying Archive pages.
 *
 * @package Sela
 */

get_header(); ?>



<div class="content-wrapper full-width without-featured-image">

		<header class="entry-header">
			<h1 class="entry-title">Carnet de recettes</h1>
			<h2 class="taxo-filter">Ingrédient principal : <?php echo $wp_query->queried_object->name; ?></h2>
		</header><!-- .entry-header -->

		<div class="entry-content">
			<p>Vous avez sélectionné toutes les recettes ayant pour ingrédient principal : <?php echo $wp_query->queried_object->name; ?>.</p>
			<p>Accédez rapidement à une recette par son nom. Ou recherchez des recettes par type de plats ou par ingrédient principal.<br/>
			Vous pouvez aussi simplement naviguer dans le carnet de recettes. Les recettes sont rangées de la plus récente à la plus ancienne.</p>
		</div>

		<?php get_sidebar( 'recette-archive' ); ?>

		<div id="primary" class="content-area grid-page-content-area ">
			<div id="content" class="site-content" role="main">

				<?php if ( have_posts() ) : ?>

					<!--<header class="page-header">
						<?php
							the_archive_title( '<h1 class="page-title">', '</h1>' );
							the_archive_description( '<div class="taxonomy-description">', '</div>' );
						?>
					</header><!-- .page-header -->

					<div class="child-pages grid">

						<?php /* Start the Loop */ ?>
						<?php while ( have_posts() ) : the_post(); ?>

							<?php
								/* Include the Post-Format-specific template for the content.
								 * If you want to override this in a child theme then include a file
								 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
								 */
								get_template_part( 'content', 'grid' );
							?>

						<?php endwhile; ?>

					</div><!-- .child-pages .grid -->

					<?php sela_content_nav( 'nav-below' ); ?>

				<?php else : ?>

					<?php get_template_part( 'content', 'none' ); ?>

				<?php endif; ?>

			</div><!-- #content -->
		</div><!-- #primary -->
	</div><!-- .content-wrapper -->

<?php get_footer(); ?>