<?php 

/**
 * AMAP THEME functions and definitions
 * CHILD Sela theme
 */


$found = locate_template( 'widgets/text_CPT.php', TRUE, TRUE );
$found = locate_template( 'widgets/list_CPT.php', TRUE, TRUE );

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'sela', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'amap', get_stylesheet_directory_uri() . '/style.css' );

}

/**
 * Création des custom post type (recette, breve, feuille)
 */

// Création des types de plats et des ingredients types (catégorie et mots clés pour les recettes)
add_action( 'init', 'create_custom_taxonomies', 0 );

function create_custom_taxonomies() {

	$plats_labels = array(
		'name'              => _x( 'Plats', 'taxonomy general name' ),
		'singular_name'     => _x( 'Plat', 'taxonomy singular name' ),
		'search_items'      => __( 'Chercher parmi les types de plats' ),
		'all_items'         => __( 'Tous les plats' ),
		'edit_item'         => __( 'Modifier le type de plat' ),
		'update_item'       => __( 'Mettre à jour le type de plat' ),
		'add_new_item'      => __( 'Ajouter un type de plat' ),
		'new_item_name'     => __( 'Nouveau type de plat' ),
		'menu_name'         => __( 'Plat' ),
	);

	$plats_args = array(
		'hierarchical'      => true,
		'labels'            => $plats_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'plat' ),
	);

	register_taxonomy( 'plat', array( 'recette' ), $plats_args ); 
	
	$ingredients_labels = array(
		'name'              => _x( 'Ingrédients', 'taxonomy general name' ),
		'singular_name'     => _x( 'Ingrédient', 'taxonomy singular name' ),
		'search_items'      => __( 'Chercher parmi les ingrédients' ),
		'all_items'         => __( 'Tous les ingrédients' ),
		'edit_item'         => __( 'Modifier l\'ingrédient' ),
		'update_item'       => __( 'Mettre à jour l\'ingrédient' ),
		'add_new_item'      => __( 'Ajouter un ingrédient' ),
		'new_item_name'     => __( 'Nouvel ingrédient' ),
		'menu_name'         => __( 'Ingrédient' ),
	);

	$ingredients_args = array(
		'hierarchical'      => false,
		'labels'            => $ingredients_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'ingredient' ),
	);

	register_taxonomy( 'ingredient', array( 'recette' ), $ingredients_args ); 
}
 
// Création du CPT recette
add_action( 'init', 'create_post_type' );
function create_post_type() {
	
  register_post_type( 'recette',
    array(
      'labels' => array(
        'name' => __( 'Recettes' ),
        'singular_name' => __( 'Recette' ),
		'menu_name'           => __( 'Recettes' ),
		'name_admin_bar'      => __( 'Recettes' ),
		'all_items'           => __( 'Toutes les recettes' ),
		'add_new_item'        => __( 'Ajouter une nouvelle recette' ),
		'add_new'             => __( 'Ajouter', 'text_domain' ),
		'new_item'            => __( 'Nouvelle recette', 'text_domain' ),
		'edit_item'           => __( 'Modifier la recette', 'text_domain' ),
		'update_item'         => __( 'Mettre à jour la recette', 'text_domain' ),
		'view_item'           => __( 'Voir la recette', 'text_domain' ),
		'search_items'        => __( 'Rechercher une recette', 'text_domain' ),
      ),
      'public' 				=> true,
      'has_archive' 		=> true,
	  'rewrite' 			=> array('slug' => 'recette'),
	  'supports'            => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'custom-fields', 'comments'),
		'taxonomies'          => array( 'plat', 'ingredient' ),
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 28,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
    )
  );
}

// Création du CPT breve
add_action( 'init', 'create_post_type_breve' );
function create_post_type_breve() {
	
  register_post_type( 'breve',
    array(
      'labels' => array(
        'name' => __( 'Brèves' ),
        'singular_name' 	  => __( 'Brève' ),
		'menu_name'           => __( 'Brèves' ),
		'name_admin_bar'      => __( 'Brèves' ),
		'all_items'           => __( 'Toutes les brèves' ),
		'add_new_item'        => __( 'Ajouter une nouvelle brève' ),
		'add_new'             => __( 'Ajouter', 'text_domain' ),
		'new_item'            => __( 'Nouvelle brève', 'text_domain' ),
		'edit_item'           => __( 'Modifier la brève', 'text_domain' ),
		'update_item'         => __( 'Mettre à jour la brève', 'text_domain' ),
		'view_item'           => __( 'Voir la brève', 'text_domain' ),
		'search_items'        => __( 'Rechercher une brève', 'text_domain' ),
      ),
      'public' => true,
      'has_archive' 		=> true,
	  'rewrite' 			=> array('slug' => 'breve'),
	  'supports'            => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'custom-fields', 'comments'),
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 28,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
    )
  );
}

// Création du CPT feuille de chou
add_action( 'init', 'create_post_type_chou' );
function create_post_type_chou() {
	
  register_post_type( 'feuille-de-chou',
    array(
    	'labels' => array(
	        'name' 				=> __( 'Feuilles de chou' ),
	        'singular_name' 	=> __( 'Feuille de chou' ),
			'menu_name'         => __( 'Feuilles de chou' ),
			'name_admin_bar'    => __( 'Feuilles de chou' ),
			'all_items'         => __( 'Toutes les feuilles de chou' ),
			'add_new_item'      => __( 'Ajouter une nouvelle feuille de chou' ),
			'add_new'           => __( 'Ajouter', 'text_domain' ),
			'new_item'          => __( 'Nouvelle feuille de chou', 'text_domain' ),
			'edit_item'         => __( 'Modifier la feuille de chou', 'text_domain' ),
			'update_item'       => __( 'Mettre à jour la feuille de chou', 'text_domain' ),
			'view_item'         => __( 'Voir la feuille de chou', 'text_domain' ),
			'search_items'      => __( 'Rechercher une feuille de chou', 'text_domain' ),
	      ),
	    'public' 				=> true,
	    'has_archive' 			=> true,
		'rewrite' 				=> array( 'slug' => 'feuille-de-chou' ),
		'supports'           	=> array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'custom-fields', 'comments'),
		'show_ui'             	=> true,
		'show_in_menu'        	=> true,
		'menu_position'       	=> 29,
		'show_in_admin_bar'   	=> true,
		'show_in_nav_menus'   	=> true,
		'can_export'          	=> true,
		'exclude_from_search' 	=> false,
		'publicly_queryable'  	=> true,
		'capability_type'     	=> 'post',
    )
  );
}



/* customisation commentaires */

function amap_comment_form_default_fields ( $fields ) {

	$req      = get_option( 'require_name_email' );
	$user = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';
	
	$fields =  array(

	  	'author' => '<p class="comment-form-author">' . '<label for="author">' . __( 'Name' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
		            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . $html_req . ' /></p>',
		'email'  => '<p class="comment-form-email"><label for="email">' . __( 'Email' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
		            '<input id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-describedby="email-notes"' . $aria_req . $html_req  . ' /></p>',
		'url'    => '',
	);
	
	$args =  array(

	  'id_form'           => 'commentform',
	  'id_submit'         => 'submit',
	  'class_submit'      => 'submit',
	  'name_submit'       => 'submit',
	  'title_reply'       => __( 'Leave a Reply' ),
	  'title_reply_to'    => __( 'Leave a Reply to %s' ),
	  'cancel_reply_link' => __( 'Cancel Reply' ),
	  'label_submit'      => __( 'Post Comment' ),
	  'format'            => 'xhtml',

	  'comment_field' =>  '<p class="comment-form-comment"><label for="comment">' . _x( 'Comment', 'noun' ) .
	    '</label><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true">' .
	    '</textarea></p>',

	  'must_log_in' => '<p class="must-log-in">' .
	    sprintf(
	      __( 'You must be <a href="%s">logged in</a> to post a comment.' ),
	      wp_login_url( apply_filters( 'the_permalink', get_permalink() ) )
	    ) . '</p>',

	  'logged_in_as' => '<p class="logged-in-as">' .
	    sprintf(
	    __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>' ),
	      admin_url( 'profile.php' ),
	      $user_identity,
	      wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) )
	    ) . '</p>',

	  'comment_notes_before' => '<p class="comment-notes">' .
	    __( 'Your email address will not be published.' ) . ( $req ? $required_text : '' ) .
	    '</p>',

	  'comment_notes_after' => '',

	  'fields' => apply_filters( 'comment_form_default_fields', $fields ),
			
	);
	
return $args;
} 
	
add_filter( 'comment_form_defaults', 'amap_comment_form_default_fields' );

/**
 * Custom template tags for this theme.
 */
require get_stylesheet_directory() . '/inc/template-tags.php';

/**
 * Register widgetized area and update sidebar with default widgets.
 */
function amap_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'First CPT Archive Widget Area', 'sela' ),
		'id'            => 'sidebar-8',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Second CPT Archive Widget Area', 'sela' ),
		'id'            => 'sidebar-9',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Third CPT Archive Widget Area', 'sela' ),
		'id'            => 'sidebar-10',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'amap_widgets_init' );


