<?php
/**
 * Template Name: Front Page
 *
 * @package Sela
 */

get_header(); ?>

<div id="primary" class="content-area front-page-content-area">
	<?php while ( have_posts() ) : the_post(); ?>
		<div class="hero">
			<?php if ( has_post_thumbnail() ) : ?>
				<figure class="hero-content">
					<?php the_post_thumbnail( 'sela-hero-thumbnail' ); ?>
					<div class="hero-content-overlayer">
						<div class="hero-container-outer">
							<div class="hero-container-inner">
								<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
									<header class="entry-header">
										<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
									</header><!-- .entry-header -->

									<div class="entry-content">
										<?php the_content(); 
										//edit_post_link( __( 'Edit', 'sela' ), '<span class="edit-link">', '</span>' ); ?>
									</div><!-- .entry-content -->
									
									<?php 
									$args = array(
										'post_type' 		=> 'breve',
										'order_by'			=> 'date',
										'order'				=> 'DESC',
										'posts_per_page' 	=> 1
										);
									
									$the_query = new WP_Query( $args );
									//var_dump($the_query->query_vars);
									
									if ( $the_query->have_posts() ) :
										while ( $the_query->have_posts() ) :
											$the_query->the_post(); ?>
											<div class="breve">
												<h3 class="entry-title">Information de dernière minute</h3>
												<?php the_content(); ?>
											</div>
										<?php endwhile; ?>
									<?php else : ?>
									<?php endif;
									
									wp_reset_postdata();
									?>
								</article><!-- #post-## -->
							</div><!-- .hero-container-inner -->
						</div><!-- .hero-container-outer -->
					</div><!-- .hero-content-overlayer -->
				</figure><!-- .hero-content -->

			<?php else : ?>
				<?php get_template_part( 'content', 'page' ); ?>
				<?php 
				$args = array(
					'post_type' 		=> 'breve',
					'order_by'			=> 'date',
					'order'				=> 'DESC',
					'posts_per_page' 	=> 1
					);
				
				$the_query = new WP_Query( $args );
				//var_dump($the_query->query_vars);
				
				if ( $the_query->have_posts() ) :
					while ( $the_query->have_posts() ) :
						$the_query->the_post(); ?>
						<div class="breve">
							<h3 class="entry-title">Information de dernière minute</h3>
							<?php the_content(); ?>
						</div>
					<?php endwhile; ?>
				<?php else : ?>
				<?php endif;
				
				wp_reset_postdata();
				?>
			<?php endif; ?>

		</div><!-- .hero -->
	<?php endwhile; ?>
</div><!-- #primary -->

<?php get_sidebar( 'front-page' ); ?>
<?php get_sidebar( 'footer' ); ?>
<?php get_footer(); ?>