<?php
/**
 * The template used for displaying recette content.
 *
 * @package Sela
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php sela_post_thumbnail(); ?>

	<header class="entry-header ">
		<?php if ( is_single() ) : ?>
			<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
		<?php else : ?>
			<?php the_title( '<h1 class="entry-title"><a href=" ' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' ); ?></a>
		<?php endif; ?>
	</header><!-- .entry-header -->

	
	<div class="entry-body">

		<div class="entry-meta">
			<?php sela_entry_meta(); ?>
		</div><!-- .entry-meta -->

		<div class="entry-content">

			<?php if( have_rows('liste-ingredients') ): ?>

				<table class="ingredients">
					<tr>
						<th>Ingrédient</th>
						<th>Quantité</th>
					</tr>

					<?php while( have_rows('liste-ingredients') ): the_row(); 

						// vars
						$ingredient = get_sub_field('ingredient');
						$quantite = get_sub_field('quantite');

						?>

						<tr>
							<td class="ingredient">
								<?php if( $ingredient ) echo $ingredient; ?>
							</td>
							<td class="quantite">
								<?php if( $quantite ) echo $quantite; ?>
							</td>

						</tr>

					<?php endwhile; ?>

				</table>

			<?php endif; ?>

			<h3 class="titre_ds_recette">Recette</h3>

			<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'sela' ) ); ?>

			<?php if ( get_field('astuces') ) : ?>
					<h3 class="titre_ds_recette">Astuces</h3>
					<?php the_field('astuces'); ?>
			<?php endif; ?>
			
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . __( 'Pages:', 'sela' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->

		<?php if ( is_single() && 'post' == get_post_type() ) : ?>
		<footer class="entry-meta">
			<?php sela_footer_entry_meta(); ?>
		</footer><!-- .entry-meta -->
		<?php endif; ?>
	</div><!-- .entry-body -->

</article><!-- #post-## -->